<?php
include "../controllers/settings.php";
$settings = new Settings();
$s = $settings->getFirst();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings->setParams($_POST, $_FILES);
    $settings->updateOneSignal();
    $s = $settings->getById($s["id"]);
}
?>

<!-- Content Header (Page header) -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">پیکربندی نوتیفکیشن</h1>
        <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="index.php">داشبورد</a></li>
            <li class="breadcrumb-item active">پیکربندی پوشه</li>
        </ol>
    </div>

    <div>
        <div class="card shadow mb-4">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">پیکربندی پوشه</h6>
            </div>
            <!-- Card Body -->
            <form method="post" action="" id="form" enctype="multipart/form-data">
                <div class="card-body">

                    <div class="row">
                        <input type="hidden" id="id" name="id" value="<?= $s['id'] ?>">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="onesignal_id">آیدی اپلیکیشن</label>
                                <input type="text" class="form-control" id="onesignal_id" name="onesignal_id" value="<?= $s['onesignal_id'] ?>" placeholder="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="onesignal_api_key">کلید API</label>
                                <input type="text" class="form-control" id="onesignal_api_key" name="onesignal_api_key" value="<?= $s['onesignal_api_key'] ?>" placeholder="Rest Api Key" required>
                            </div>
                        </div>

                    </div>

                    <button type="submit" class="btn btn-primary btn-icon-split mt-3">
						<span class="icon text-white-50">
							<i class="fas fa-save"></i>
						</span>
                        <span class="text">ذخیره</span>
                    </button>

                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {

        $('#form').validate({
            rules: {
                onesignal_id: {
                    required: true,
                },
                onesignal_id: {
                    required: true,
                }
            },
            messages: {
                onesignal_id: {
                    required: "لطفا آیدی اپلیکیشن را وارد کنید",
                },
                onesignal_api_key: {
                    required: "لطفا کلیدAPI را وارد کنید",
                }
            },
            errorElement: 'div',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>