<?php
include "../controllers/settings.php";
$settings = new Settings();
$s = $settings->getFirst();
$navigatin_option = array(
	array(
		'value' => 'left',
		'title' => 'منوی ناوبری سمت چپ'
	),

	array(
		'value' => 'center',
		'title' => 'منوی ناوبری وسط'
	),

	array(
		'value' => 'right',
		'title' => 'منوی ناوبری سمت راست'
	),

	array(
		'value' => 'empty',
		'title' => 'یدون منوی ناوبری'
	)
);

$loader_option = array(
	array(
		'value' => 'RotatingPlain',
		'title' => 'صفحه چرخان'
	),
	array(
		'value' => 'DoubleBounce',
		'title' => 'دو حباب'
	),
	array(
		'value' => 'Wave',
		'title' => 'موج'
	),
	array(
		'value' => 'WanderingCubes',
		'title' => 'دایره موازی'
	),
	array(
		'value' => 'FadingFour',
		'title' => 'چهار دایره محوشوند'
	),
	array(
		'value' => 'FadingCube',
		'title' => 'مکعب محو شونده'
	),

	array(
		'value' => 'Pulse',
		'title' => 'پالس'
	),
	array(
		'value' => 'ChasingDots',
		'title' => 'نقطه های چرخان'
	),
	array(
		'value' => 'ThreeBounce',
		'title' => 'سه نقطه چرخان'
	),
	array(
		'value' => 'Circle',
		'title' => 'دایره'
	),
	array(
		'value' => 'CubeGrid',
		'title' => 'شبکه مکعبی'
	),
	array(
		'value' => 'FadingCircle',
		'title' => 'دایره محو شونده'
	),

	array(
		'value' => 'RotatingCircle',
		'title' => 'دایره چرخان'
	),
	array(
		'value' => 'FoldingCube',
		'title' => 'مکعب روان'
	),
	array(
		'value' => 'PumpingHeart',
		'title' => 'قلب تپنده'
	),
	array(
		'value' => 'DualRing',
		'title' => 'رینگ دوتایی'
	),
	array(
		'value' => 'HourGlass',
		'title' => 'پره'
	),
	array(
		'value' => 'PouringHourGlass',
		'title' => 'پره چهارتایی'
	),

	array(
		'value' => 'FadingGrid',
		'title' => '9 نقطه'
	),
	array(
		'value' => 'Ring',
		'title' => 'حلفه'
	),
	array(
		'value' => 'Ripple',
		'title' => 'پالس دایره ایی'
	),
	array(
		'value' => 'SpinningCircle',
		'title' => 'دایره چرخان'
	),
	array(
		'value' => 'SquareCircle',
		'title' => 'دایره به مربع'
	),
	array(
		'value' => 'empty',
		'title' => 'بدون انیمیشن'
	),
);

$title_option = array(
	array(
		'value' => 'text',
		'title' => 'متن'
	),
	array(
		'value' => 'image',
		'title' => 'عکس'
	),
	array(
		'value' => 'empty',
		'title' => 'خالی'
	)
);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	$settings->setParams($_POST, $_FILES);
	$settings->update();
	$s = $settings->getById($s["id"]);
}
?>

<!-- Content Header (Page header) -->
<div class="container-fluid">

	<!-- Page Heading -->
	<div class="d-sm-flex align-items-center justify-content-between mb-4">
		<h1 class="h3 mb-0 text-gray-800">تنظیمات</h1>
		<ol class="breadcrumb float-sm-right">
			<li class="breadcrumb-item"><a href="index.php">داشبورد</a></li>
			<li class="breadcrumb-item active">تنظیمات</li>
		</ol>
	</div>

	<div>
		<div class="card shadow mb-4">
			<!-- Card Header - Dropdown -->
			<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
				<h6 class="m-0 font-weight-bold text-primary">تنظیمات</h6>
			</div>
			<!-- Card Body -->
			<form method="post" action="" id="form" enctype="multipart/form-data">
				<div class="card-body">
					<div class="row">
						<div class="col-md-6">
							<input type="hidden" id="id" name="id" value="<?= $s['id'] ?>">

							<div class="form-group">
								<label for="title">عنوان هدر</label>
								<input type="text" class="form-control" id="title" name="title" placeholder="Title" value="<?= $s['title'] ?>" required>
							</div>
							<div class="form-group">
								<label for="url">آدرس سایت</label>
								<input type="text" class="form-control" id="url" name="url" placeholder="URL" value="<?= $s['url'] ?>" required>
							</div>

							<!-- /.form-group -->

							<div class="form-group">
								<label for="loader">انتخاب انیمیشن لودینگ</label>

								<div class="d-flex justify-content-between">
									<select class="form-control loader" id="loader" name="loader" style="width: 100%;">
										<?php
										foreach ($loader_option as $option) {
										?>
											<option value="<?= $option['value'] ?>" <?php echo ($option['value'] == $s['loader']) ? ' selected="selected"' : ''; ?>><?= $option["title"] ?></option>
										<?php } ?>
									</select>
									<img src="../img/loading/<?= $s['loader'] ?>.gif" id="image_loader" style="height:40px; width: 40px; margin-left:5px" />
								</div>

							</div>
							<!-- /.form-group -->


							<!-- Color Picker -->
							<div class="form-group">
								<label>رنگ بارگذاری کننده :</label>
								<div class="input-group loaderColor">
									<input type="text" class="form-control" id="loaderColor" name="loaderColor" value="<?= $s['loaderColor'] ?>">
									<div class="input-group-append">
										<span class="input-group-text">
											<i class="fas fa-square" style="color:<?= $s['loaderColor'] ?> "></i>
										</span>
									</div>
								</div>
								<!-- /.input group -->
							</div>


							<div class="form-group">
								<label for="logo_header">لگو هدر:</label>
								<div class="input-group">
									<div class="custom-file">
										<input type="file" class="custom-file-input" id="logo_header" name="logo_header" onChange="readURLLogo(this);">
										<label class="custom-file-label text-center" for="logo_header">انتخاب فایل</label>
									</div>
								</div>
							</div>
							<div class="form-group">
								<img src="../images/settings/<?= $s["logo_header"] ?>?<?= time() ?>" style="width:100px; background-color: #bdbdbd" id="thumb_img_logo" class="img-thumbnail">
							</div>
							<!--
							<div class="form-group">
								<label for="image">Logo</label>
								<div class="input-group">
									<div class="custom-file">
										<input type="file" class="custom-file-input" id="image" name="image" onChange="readURL(this);">
										<label class="custom-file-label" for="image">انتخاب فایل</label>
									</div>
								</div>
							</div> 
							<div class="form-group">
								<img src="../images/settings/<?= $s["logo"] ?>?<?= time() ?>" style="width:100px; background-color: #bdbdbd" id="thumb_img" class="img-thumbnail">
							</div> 
							-->
						</div>
						<!-- /.col -->
						<div class="col-md-6">
							<div class="form-group">
								<label for="sub_title">شعار اپلیکیشن</label>
								<input type="text" class="form-control" id="sub_title" name="sub_title" placeholder="Sub Title" value="<?= $s['sub_title'] ?>" required>
							</div>
							<div class="form-group">
								<label for="navigatin_bar_style">انتخاب استایل منوی ناوبری</label>
								<select class="form-control navigatin_bar_style" id="navigatin_bar_style" name="navigatin_bar_style" style="width: 100%;">
									<?php
									foreach ($navigatin_option as $option) {
									?>
										<option value="<?= $option['value'] ?>" <?php echo ($option['value'] == $s['navigatin_bar_style']) ? ' selected="selected"' : ''; ?>><?= $option["title"] ?></option>
									<?php } ?>
								</select>
							</div>

							<div class="form-group">
								<label for="type_header">انتخاب نوع هدر </label>
								<select class="form-control" id="type_header" name="type_header" style="width: 100%;">
									<?php
									foreach ($title_option as $option) {
									?>
										<option value="<?= $option['value'] ?>" <?php echo ($option['value'] == $s['type_header']) ? ' selected="selected"' : ''; ?>><?= $option["title"] ?></option>
									<?php } ?>
								</select>
							</div>

							<div class="form-group">
								<label for="pull_refresh">دکمه رفرش</label>
								<div class="custom-control custom-switch">
									<input type="checkbox" class="custom-control-input pull_refresh" id="pull_refresh" name="pull_refresh" data-bootstrap-switch <?php echo ($s["pull_refresh"] == "1") ? ' checked="checked"' : ''; ?> />
									<label class="custom-control-label" for="pull_refresh"></label>
								</div>
							</div>

							<div class="form-group">
								<label for="boarding">صفحه معرفی اولیه</label>
								<div class="custom-control custom-switch">
									<input type="checkbox" class="custom-control-input boarding" id="boarding" name="boarding" data-bootstrap-switch <?php echo ($s["boarding"] == "1") ? ' checked="checked"' : ''; ?> />
									<label class="custom-control-label" for="boarding"></label>
								</div>
							</div>

							<div class="form-group">
								<label for="title">لینک دهی عمیق</label>
								<input type="text" class="form-control" id="deeplink" name="deeplink" placeholder="Deeplink" value="<?= $s['deeplink'] ?>" required>
							</div>
						</div>
						<!-- /.col -->
					</div>
					<button type="submit" class="btn btn-primary btn-icon-split">
						<span class="icon text-white-50">
							<i class="fas fa-save"></i>
						</span>
						<span class="text">ذخیره</span>
					</button>
				</div>
			</form>
		</div>
	</div>
</div>

<script type="text/javascript">
	$(document).ready(function() {

		$("#loader").on('change', function() {
			$('#image_loader').attr('src', '../img/loading/' + this.value + '.gif');
		});

		$("#right_button").on('change', function() {
			$('#image_right_button').attr('src', '../img/button/' + this.value + '.png');
		});

		$("#left_button").on('change', function() {
			$('#image_left_button').attr('src', '../img/button/' + this.value + '.png');
		});

		$('#form').validate({
			rules: {
				title: {
					required: true,
				},
				url: {
					url: true
				}
			},
			messages: {
				title: {
					required: "لطفا عنوان را وارد کنید",
				},
				url: {
					required: "لطفا آدرس را وارد کنید",
					url: "لطفا آدرس معتبر وارد کنید(http://www.example.com)",
				}
			},
			errorElement: 'div',
			errorPlacement: function(error, element) {
				error.addClass('invalid-feedback');
				element.closest('.form-group').append(error);
			},
			highlight: function(element, errorClass, validClass) {
				$(element).addClass('is-invalid');
			},
			unhighlight: function(element, errorClass, validClass) {
				$(element).removeClass('is-invalid');
			}
		});
	});
</script>


<script>
	$("input#loaderColor").ColorPickerSliders({
		hsvpanel: true,
		previewformat: 'hex',
		onchange: function(container, color) {
			$('.loaderColor .fa-square').css('color', color.tiny.toHexString());
			$('.linearGradient').css('background', 'linear-gradient(135deg, ' + $("#firstColor").val() + ', ' + color.tiny.toHexString() + ' )');
		}
	});
</script>